// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Objekt.cc
//
//	erstellt 5.1.98 von Andreas Warnke
//	geändert 6.5.98 von Andreas Warnke
//



#include "Objekt.h"
#include "AsciiKette.h"
#include "AVLNode.h"



// // // // // // // // // // // // // // // //
//
//	static:
//

unsigned int Objekt :: NextID = 1;



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

Objekt :: Objekt ()
{
	//	Default-Werte
	Typ = Obj_NoObject;
	BelongsTo = 0;
 	BusyTill = real_time_clock_usecs();
	SetAVLKey ( NextID );
	NextID ++;
	XPos = -1;
	YPos = 0;
	MoveToX = 0;
	MoveToY = 0;
};



// // // // // // // // // // // // // // // //
//
//	2. Konstruktor: (für Server)
//

Objekt :: Objekt (
	unsigned int inType,
	unsigned int inOwner,
	int inX,
	int inY,
	bigtime_t inBusyTill )
{
	Typ = inType;
	BelongsTo = inOwner;
	XPos = inX;
	YPos = inY;
	MoveToX = inX;
	MoveToY = inY;
	if ( inBusyTill == 1 )
		BusyTill = real_time_clock_usecs();
	else
		BusyTill = inBusyTill;
	SetAVLKey ( NextID );
	NextID ++;
};



// // // // // // // // // // // // // // // //
//
//	3. Konstruktor: (für Client)
//

Objekt :: Objekt (
	unsigned int inID,
	unsigned int inType,
	unsigned int inOwner,
	int inX,
	int inY,
	bigtime_t inBusyTill )
{
	Typ = inType;
	BelongsTo = inOwner;
	XPos = inX;
	YPos = inY;
	MoveToX = inX;
	MoveToY = inY;
	BusyTill = inBusyTill;
	SetAVLKey ( inID );
};



// // // // // // // // // // // // // // // //
//
//	copy-Konstruktor:
//

Objekt :: Objekt ( const Objekt & inOriginal )
{
	//	Kopie:
	Typ = inOriginal . Typ;
	BelongsTo = inOriginal . BelongsTo;
	XPos = inOriginal . XPos;
	YPos = inOriginal . YPos;
	BusyTill = inOriginal . BusyTill;
	SetAVLKey ( inOriginal . GetID () );
	MoveToX = inOriginal . MoveToX;
	MoveToY = inOriginal . MoveToY;
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

Objekt :: ~Objekt ()
{
	//	Ungültig-Werte
	Typ = Obj_NoObject;
};



// // // // // // // // // // // // // // // //
//
//	GetID:
//

unsigned int Objekt :: GetID () const
{
	return AVLKey ();
};



//
//	Ende.
//
// // // // // // // // // // // // // // // //